import { Button, Dropdown, DropdownItem, DropdownMenu, DropdownTrigger, Tooltip } from '@nextui-org/react'
import { withAuth } from '@/auth/withAuth'
import type { WithAuthProps } from '@/auth/withAuth'
import UserIcon from '@/assets/svg/user.svg?react'
import { useAuth } from '@/auth/AuthContext'

interface UserProps {
  onLogout: () => void
}

export const UserLogin: React.FC<UserProps> = ({ onLogout }) => {
  const { logout } = useAuth()
  const items = [
    // {
    //   key: 'conact',
    //   label: '联系我们',
    // },
    // {
    //   key: 'file',
    //   label: '相关协议',
    // },
    {
      key: 'logout',
      label: '退出登录',
    },
  ]
  const handleClick = (key: string) => {
    if (key === 'logout') {
      logout()
      onLogout()
    }
  }
  return (
    <Dropdown>
      <DropdownTrigger>
        <Button variant="light" isIconOnly aria-label="Like">
          <UserIcon />
        </Button>
      </DropdownTrigger>
      <DropdownMenu variant="flat" aria-label="Dynamic Actions" items={items}>
        {item => (
          <DropdownItem
            onClick={() => handleClick(item.key)}
            key={item.key}
            color={item.key === 'logout' ? 'danger' : 'primary'}
            className={item.key === 'logout' ? 'text-danger' : ''}
          >
            {item.label}
          </DropdownItem>
        )}
      </DropdownMenu>
    </Dropdown>

  )
}

const UserNotLoginBase: React.FC<WithAuthProps> = ({ showLoginTip, checkAuth }) => {
  return (
    <Tooltip isOpen={showLoginTip} color="foreground" content="登录体验更多功能" placement="right">
      <Button onClick={checkAuth} variant="light" isIconOnly aria-label="Like">
        <UserIcon />
      </Button>
    </Tooltip>
  )
}
export const UserNotLogin = withAuth(UserNotLoginBase)

export const User: React.FC<UserProps> = ({ onLogout }) => {
  const { isLoggedIn } = useAuth()
  return isLoggedIn ? <UserLogin onLogout={onLogout} /> : <UserNotLogin />
}
