interface AttachmentContentDoc {
  knowledgeName: string
  collectionName: string
  documentName: string
  documentAlias: string
  documentStoreKey: string
}

interface AttachmentContentProduct {
  productName: string
  productCode: string
}

interface AttachmentContent {
  docList: AttachmentContentDoc[]
  description: string
  productList: AttachmentContentProduct[]
  url: string
}

export interface Attachment {
  type: string
  name: string
  url: string
  description: string
  content: AttachmentContent
}

interface AnswerStep {
  step: string
  message: string
}

export interface Answer {
  endAnswerFlag?: boolean
  isStopTyping?: boolean
  isChatMaxCount?: boolean
  isShow: boolean
  answer: string
  collectionFlag?: boolean
  feedbackStatus?: string
  groupId?: string
  question?: string
  recordId?: string
  conversationId?: string
  terminateFlag?: boolean
  toolName?: string
  cardList: Attachment[]
  step?: AnswerStep
}

export interface OriginalRecord {
  answer?: string
  groupId?: string
  question?: string
  answerList: Answer[]
  productCode?: string
  qaTime?: string
}

export type ChatRecordRole = 'system' | 'user' | 'ai'

export interface ChatRecord extends OriginalRecord {
  role: ChatRecordRole
}

export interface ChatState {
  records: ChatRecord[]
  isLoading: boolean
  error: string | null
}
