import ReactMarkdown from 'react-markdown'
import rehypeRaw from 'rehype-raw'
import rehypeSanitize from 'rehype-sanitize'
import remarkGfm from 'remark-gfm'
import { formatMarkdown } from './markdownFormatter'
import { ChatAnswerAttachment } from './ChatAnswerAttchment'
import type { Answer } from '@/types/chat'

interface ChatAnswerShowerProps {
  answer: Answer
}

export const ChatAnswerShower: React.FC<ChatAnswerShowerProps> = ({ answer }) => {
  return (
    <div className="answerShower">
      <ReactMarkdown
        rehypePlugins={[rehypeRaw, rehypeSanitize]}
        remarkPlugins={[remarkGfm]}
        className="markdown-content"
      >
        {formatMarkdown(answer.answer || '')}
      </ReactMarkdown>

      <ChatAnswerAttachment answer={answer} />
    </div>
  )
}
