export interface Attachment {
  type: string
  name: string
  description: string
}

export interface Answer {
  answer: string
  collectionFlag?: boolean
  feedbackStatus?: string
  groupId?: string
  question?: string
  recordId?: string
  terminateFlag?: boolean
  toolName?: string
  attachmentList: Attachment[]
}

export interface OriginalRecord {
  answer?: string
  groupId?: string
  question?: string
  answerList: Answer[]
  productCode?: string
  qaTime?: string
}

export type ChatRecordType = 'system' | 'question' | 'answer' | 'streamAnswer'

export interface ChatRecord {
  type: ChatRecordType
  originalData: OriginalRecord
}

export interface ChatState {
  records: ChatRecord[]
  isLoading: boolean
  error: string | null
}
