import React, { useEffect, useState } from 'react'
import { Avatar } from '@nextui-org/react'
import { motion } from 'framer-motion'
import ReactMarkdown from 'react-markdown'
import rehypeRaw from 'rehype-raw'
import rehypeSanitize from 'rehype-sanitize'
import { formatMarkdown } from './markdownFormatter'
import type { ChatRecord } from '@/types/chat'
import AvatarBot from '@/assets/avatarBot.png'

interface ChatItemStreamProps {
  record: ChatRecord
}
export const ChatItemStream: React.FC<ChatItemStreamProps> = ({ record }) => {
  const [displayedContent, setDisplayedContent] = useState('')
  const content = record.originalData?.answerList?.[0]?.answer || ''

  useEffect(() => {
    let i = 0
    const timer = setInterval(() => {
      setDisplayedContent(content.slice(0, i))
      i++
      if (i > content.length) {
        clearInterval(timer)
      }
    }, 20) // 调整速度

    return () => clearInterval(timer)
  }, [content])
  return (
    <div className="chatItemBotContainer w-full">
      <div className="flex">
        <Avatar className="flex-shrink-0" src={AvatarBot} />
        <motion.div
          className="ml-[20px] bg-white rounded-[20px] box-border px-[24px] py-[20px]"
        >
          <div className="content">
            <ReactMarkdown
              rehypePlugins={[rehypeRaw, rehypeSanitize]}
              className="markdown-content"
            >
              {formatMarkdown(displayedContent)}
            </ReactMarkdown>
          </div>
        </motion.div>
        <div className="w-[130px]"></div>
      </div>
      <div className="h-[32px] w-full"></div>
    </div>
  )
}
