import { ChatWelcome } from '../ChatWelcome'
import { ChatItemBot } from './ChatItemBot'
import { ChatItemStream } from './ChatItemStream'
import { ChatItemUser } from './ChatItemUser'
import type { ChatRecord } from '@/types/chat'

interface ChatItemProps {
  record: ChatRecord
}

export const ChatItem: React.FC<ChatItemProps> = ({ record }) => {
  return (
    <div className="chatItem max-w-[1000px] mx-auto">
      {record.type === 'system' && <ChatWelcome />}
      {record.type === 'question' && <ChatItemUser record={record} />}
      {record.type === 'answer' && <ChatItemBot record={record} />}
      {record.type === 'streamAnswer' && <ChatItemStream record={record} />}
    </div>
  )
}
