import React from 'react'
import { useDispatch } from 'react-redux'
import { useParams } from 'react-router-dom'
import styles from './Chat.module.less'
import { ChatSlogan } from './components/ChatSlogan'
import { ChatContent } from './components/ChatContent'
import { ChatMaskBar } from './components/ChatMaskBar'
import { RECOMMEND_QUESTIONS_OTHER } from '@/config/recommendQuestion'
import { ChatEditor } from '@/components/ChatEditor'
import type { ChatRecord } from '@/types/chat'
import { addRecord, setIsLoading, updateLastAnswer } from '@/store/chatSlice'
import { fetchCheckTokenApi, fetchStreamResponse } from '@/api/chat'

export const Chat: React.FC = () => {
  const dispatch = useDispatch()
  const { id } = useParams<{ id: string }>()

  const handleQuestion = async (question: string) => {
    // 添加用户问题
    const userRecord: ChatRecord = {
      type: 'question',
      originalData: {
        question,
        answerList: [],
      },

    }
    dispatch(addRecord(userRecord))

    setIsLoading(true)

    // 添加空的AI回答
    const aiMessage: ChatRecord = {
      type: 'streamAnswer',
      originalData: { answerList: [{ answer: '', attachmentList: [] }] },
    }
    dispatch(addRecord(aiMessage))

    await fetchCheckTokenApi()
    let fetchUrl = `/conversation/api/conversation/mobile/v1/submit_question_stream`
    const proxy = import.meta.env.MODE === 'dev' ? '/api' : '/sdream-api'
    fetchUrl = proxy + fetchUrl

    fetchStreamResponse(
      fetchUrl,
      {
        question,
        conversationId: id,
        stream: true,
      },
      (msg) => {
        if (msg.type === 'DATA') {
          dispatch(updateLastAnswer(msg.content.data))
        }
      },
    )
  }

  return (
    <div className={`${styles.chatPage} relative`}>
      <ChatSlogan />
      <ChatMaskBar />
      <div className={styles.content}>
        <ChatContent />
      </div>
      <div className="box-border px-[0] mx-auto iptContainer w-full  max-w-[1000px] flex-shrink-0 sm:px-0 pb-[18px]">
        <ChatEditor onSubmit={handleQuestion} placeholders={RECOMMEND_QUESTIONS_OTHER} />
        <div className="w-full text-center mt-[20px] text-[#3333334d] text-[12px]">
          内容由AI模型生成，其准确性和完整性无法保证，仅供参考
        </div>
      </div>
    </div>
  )
}
