import React, { useEffect, useState } from 'react'

interface ChatAnswerTypeItProps {
  content: string
  typingSpeed?: number
}

const ChatAnswerTypeIt: React.FC<ChatAnswerTypeItProps> = ({ content, typingSpeed = 50 }) => {
  const [displayedText, setDisplayedText] = useState('')
  const [currentIndex, setCurrentIndex] = useState(0)

  useEffect(() => {
    if (currentIndex < content.length) {
      const timer = setTimeout(() => {
        setDisplayedText(prev => prev + content[currentIndex])
        setCurrentIndex(prev => prev + 1)
      }, typingSpeed)

      return () => clearTimeout(timer)
    }
  }, [content, currentIndex, typingSpeed])

  return <span>{displayedText}</span>
}

export default ChatAnswerTypeIt
