'use client'

import type { Variants } from 'framer-motion'
import { AnimatePresence, motion } from 'framer-motion'

import { cn } from '@/lib/utils'

interface GradualSpacingProps {
  text: string
  duration?: number
  delayMultiple?: number
  framerProps?: Variants
  className?: string
}

export default function GradualSpacing({
  text,
  duration = 0.5,
  delayMultiple = 0.04,
  // eslint-disable-next-line react/no-unstable-default-props
  framerProps = {
    hidden: { opacity: 0, x: -20 },
    visible: { opacity: 1, x: 0 },
  },
  className,
}: GradualSpacingProps) {
  return (
    <motion.div
      className="flex justify-center space-x-1"
    >
      <AnimatePresence>
        {text.split('').map((char, i) => (
          <motion.h1
            key={i}
            initial="hidden"
            animate="visible"
            exit="hidden"
            variants={framerProps}
            transition={{ duration, delay: i * delayMultiple }}
            className={cn('drop-shadow-sm ', className)}
          >
            {char === ' ' ? <span>&nbsp;</span> : char}
          </motion.h1>
        ))}
      </AnimatePresence>
    </motion.div>
  )
}
