# 本地包配置说明

## 概述

为了解决内网环境下 `unrs-resolver` 和 `eslint-import-context` 包安装失败的问题，我们将这些包下载到本地 `packages` 目录，并通过 `file:` 路径直接引用本地包。

## 包含的包

- `unrs-resolver@1.11.1` - Rust相关的解析器包
- `eslint-import-context@0.1.9` - ESLint导入上下文插件

## 配置方式

在 `package.json` 中直接引用本地包：

```json
{
  "dependencies": {
    "unrs-resolver": "file:packages/unrs-resolver",
    "eslint-import-context": "file:packages/eslint-import-context"
  }
}
```

## 使用方法

### 内网环境（推荐）
1. 确保 `packages` 目录中包含所需的包
2. 直接运行 `npm run dev` 启动项目
3. 项目会自动使用本地包，无需重新安装

### 如果需要重新安装依赖
```bash
# 清理之前的安装
rm -rf node_modules
rm -f package-lock.json

# 安装依赖（会使用本地包）
npm install --no-optional --legacy-peer-deps
```

## 优势

- **完全离线**：不需要网络连接
- **版本固定**：确保使用特定版本
- **快速启动**：不需要下载和编译
- **可控性强**：完全控制包的来源
- **即开即用**：包已下载，直接可用

## 注意事项

- 这些包是可选依赖，跳过它们不会影响项目正常运行
- 如果需要更新包版本，需要手动下载新版本到 `packages` 目录
- 建议将 `packages` 目录加入版本控制，确保团队环境一致
- 项目已经配置好，可以直接使用 `npm run dev` 启动
