import type React from 'react'
import { motion } from 'framer-motion'
import { useToggle } from '@reactuses/core'
import { Navbar } from '../Navbar'
import styles from './MainLayout.module.less'

interface MainLayoutProps {
  children: React.ReactNode
}

export const MainLayout: React.FC<MainLayoutProps> = ({ children }) => {
  const [isNavCollapsed, toggleNav] = useToggle(true)

  return (
    <motion.main className={styles.layoutMain}>
      <Navbar isCollapsed={isNavCollapsed} onToggle={toggleNav} />
      <motion.div className={styles.layoutContent}>
        {children}
      </motion.div>
    </motion.main>
  )
}
