import { defineConfig } from '@rsbuild/core'
import { pluginReact } from '@rsbuild/plugin-react'
import { pluginSvgr } from '@rsbuild/plugin-svgr'
import { pluginLess } from '@rsbuild/plugin-less'
import { pluginTypedCSSModules } from '@rsbuild/plugin-typed-css-modules'
import { RsdoctorRspackPlugin } from '@rsdoctor/rspack-plugin' // https://rsdoctor.dev/zh/guide/start/quick-start

const isProd = process.env.NODE_ENV === 'production'

export default defineConfig({
  plugins: [
    pluginReact(),
    pluginLess(),
    pluginTypedCSSModules(),
    pluginSvgr(),
  ],
  dev: {
    // 与本地开发有关的选项
  },
  html: {
    // 与 HTML 生成有关的选项
    title: '晓得. - 晓得解惑，让沟通更智能。',
    favicon: './src/assets/logo.png',
    appIcon: './src/assets/logo.png',
    meta: {
      'viewport': 'viewport-fit=cover, width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0',
      'keywords': '晓得,sdream,ai,众耳,insurebank,保险,智能,条款解析,人工智能大模型,AI聊天机器人,AI聊天,国内大模型公司,AI聊天,AI助手,context',
      'description': '晓得 是一个智能助手，知晓市场脉搏，引领行业潮流，晓得AI助手全方位为您保驾护航| 晓得. - 晓得解惑，让沟通更智能。',
      'apple-mobile-web-app-capable': 'yes',
      'apple-mobile-web-app-status-bar-style': 'black',
      'format-detection': 'telephone=no,email=no',
      'apple-mobile-web-app-title': '晓得',
    },
  },
  tools: {
    // 与底层工具有关的选项
    rspack(config, { appendPlugins }) {
      // 仅在 RSDOCTOR 为 true 时注册插件，因为插件会增加构建耗时
      if (process.env.RSDOCTOR) {
        appendPlugins(
          new RsdoctorRspackPlugin({
            // 插件选项
          }),
        )
      }
    },
  },
  output: {
    // 与构建产物有关的选项
    distPath: {
      image: 'assets',
      svg: 'assets',
      font: 'assets',
      media: 'assets',
    },
    cssModules: {
      localIdentName: isProd ? '[hash:base64]' : '[local]',
    },
  },
  source: {
    // 与源代码解析、编译方式相关的选项
  },
  server: {
    // 与 Rsbuild 服务器有关的选项
    // 在本地开发和预览时都会生效
  },
  security: {
    // 与 Web 安全有关的选项
  },
  performance: {
    // 与构建性能、运行时性能有关的选项
  },
  environments: {
    // 为每个环境定义不同的 Rsbuild 配置
  },
})
