import http from '@/utils/request'
import { mockFetchEfficiencyQuestionList } from '@/api/mock/home'

/**
 * 查询推荐问题列表
 * @params
 */
export function fetchQuestionList(data: any) {
  return http.post('/config-center/api/commonconfig/mobile/v1/query_config_list', data)
}

/**
 * 查询工具列表
 * @params params.userRoles: 角色数组，用于按角色返回工具
 */
export function fetchToolList(params?: { userRoles?: string[] }) {
  const requestBody: Record<string, string | string[]> = {
    toolType: '03',
    userRoles: [],
  }
  if (params?.userRoles)
    requestBody.userRoles = params.userRoles
  return http.post('/config-center/api/tool/mobile/v1/get_tool_list', requestBody)
}

/**
 * 查询 提质增效 推荐问题列表
 * @params
 * toolId: 工具id
 */
const shouldUseEfficiencyMock = (import.meta as any).env?.VITE_USE_EFFICIENCY_MOCK === 'true'

export async function fetchEfficiencyQuestionList(data: any) {
  if (shouldUseEfficiencyMock)
    return mockFetchEfficiencyQuestionList()

  try {
    return await http.post('/conversation/api/conversation/mobile/v1/generate_question', data)
  }
  catch (error) {
    console.warn('fetchEfficiencyQuestionList fallback to mock due to error:', error)
    return mockFetchEfficiencyQuestionList()
  }
}
