import React from 'react'
import { formatMarkdown } from './markdownFormatter'
import { ChatAnswerAttachment } from './ChatAnswerAttchment'
import { ChatAnswerOperate } from './ChatAnswerOperate'
import type { Answer } from '@/types/chat'
import { MarkdownDetail } from '@/components/MarkdownDetail'

interface ChatAnswerShowerProps {
  answer: Answer
  isLastAnswer: boolean
  onSubmitQuestion: (question: string) => void
  hideOperate?: boolean
}

export const ChatAnswerShower: React.FC<ChatAnswerShowerProps> = ({ answer, isLastAnswer, onSubmitQuestion, hideOperate: hideOperateProp }) => {
  const hideOperateByCard = (answer.cardList || []).some(attachment => attachment.type === 'box' || attachment?.type?.includes('card-'))
  const hideOperate = hideOperateByCard || hideOperateProp
  return (
    <div className="answerShower">
      {answer.answer && (
        <div className={answer.cardList?.length ? 'mb-[12px] sm:mb-[20px]' : ''}>
          <MarkdownDetail>
            {formatMarkdown(answer.answer || '')}
          </MarkdownDetail>
        </div>
      )}
      {answer.cardList && answer.cardList?.length !== 0 && (
        <ChatAnswerAttachment onSubmitQuestion={onSubmitQuestion} isLastAnswer={isLastAnswer} answer={answer} />
      )}
      {/* 操作区：仅根据卡片类型 / 上层显式 hideOperate 控制是否展示 */}
      {!hideOperate && <ChatAnswerOperate answer={answer} />}
      <div className="flex text-[10px] right-[16px] text-[#d0d1d2] bottom-[4px]">AI生成</div>
    </div>
  )
}
