// 问答功能独立的 API 接口
import http from '@/utils/request'

/**
 * 查询问答功能会话列表
 */
export function fetchTacticsConversationPage<T>(data: T) {
  return http.post('/conversation/api/conversation/mobile/v1/query_user_conversation_page', data)
}

/**
 * 创建问答功能会话
 */
export function fetchCreateTacticsConversation<T>(data: T) {
  return http.post('/conversation/api/conversation/mobile/v1/get_user_conversation_session', data)
}

/**
 * 查询问答功能历史记录
 */
export function fetchTacticsQaRecordPage(conversationId: string) {
  return http.post('/conversation/api/conversation/mobile/v1/query_user_qa_record_list', { conversationId })
}

/**
 * 删除问答功能会话
 */
export function fetchDeleteTacticsConversation(conversationId: string, recordIdList: string[]) {
  return http.post('/conversation/api/conversation/mobile/v1/delete_user_qa', {
    conversationId,
    recordIdList,
  })
}
