// src/api/common.ts
import http from '@/utils/request'

/**
 * 登录
 */
export function fetchLoginByUid(uid: string) {
  return http.post('/user/api/login/mobile/v1/guest/login', {
    userId: uid,
  })
}

/**
 * 第三方登录
 */
export function fetchLoginByToken(loginCode: any) {
  return http.post('/user/api/login/mobile/v1/sso_login', {
    loginCode,
  })
}

/**
 * 获取协议列表
 */
export function fetchGetAgreementList() {
  return http.post('/config-center/api/commonconfig/mobile/v1/query_agreement_list')
}

/**
 * 获取文档链接
 * @param docId
 */
export function fetchGetDocumentLink(docId: string) {
  return http.post('/conversation/api/conversation/mobile/v1/get_document', {
    ossType: 'private',
    docId,
  })
}

/**
 * 批量获取文档链接
 * @param docIdList
 */
export function fetchGetDocumentLinks(docIdList: string[]) {
  return http.post('/conversation/api/conversation/mobile/v1/query_batch_document', {
    ossType: 'private',
    docIdList,
  })
}

/**
 * 下载文件
 * @param docId
 */
export function fetchDownloadFile(docId: string) {
  return http.post('/conversation/api/conversation/mobile/v1/download_file', {
    ossType: 'private',
    docId,
  }, {
    responseType: 'blob',
  })
}
