import React from 'react'
import { Route, Routes } from 'react-router-dom'
import { Home } from '../pages/Home'
import { Chat } from '../pages/Chat'
import { Collect } from '../pages/Collect'
import { Tools } from '../pages/Tools'
import { Protocol } from '../pages/Protocol'
import { withRouteChangeHandler } from './RouteChangeHandler'

const AppRoutesComponent: React.FC = () => {
  return (
    <Routes>
      <Route path="/" element={<Home />}>
        <Route path="/chat/:id" element={<Chat />} />
      </Route>
      <Route path="/home" element={<Home />}></Route>
      <Route path="/collect" element={<Collect />} />
      <Route path="/tools" element={<Tools />} />
      <Route path="/protocol/:id" element={<Protocol />} />
    </Routes>
  )
}

export const AppRoutes = withRouteChangeHandler(AppRoutesComponent)
