import { Avatar } from '@heroui/react'
import { motion } from 'framer-motion'
import AvatarBot from '@/assets/avatarBot.png'
import AIIcon from '@/assets/ai-icon.png'

interface ChatWelcomeProps {
  toolName?: string
}

export const ChatWelcome: React.FC<ChatWelcomeProps> = ({ toolName }) => {
   const viteOutputObj = import.meta.env.VITE_OUTPUT_OBJ || 'open'

  // 根据不同的 toolName 显示不同的提示语
  const getWelcomeText = () => {
    switch (toolName) {
      case '数据助手':
        return 'HI~我是您的数据助手，可以帮你查询业务数据哦'
      case '提质增效':
        return 'HI~我是您的提质增效助手，有什么可以帮您？'
      case '通用模式':
      default:
        return '您好，有什么我可以帮您的吗？'
    }
  }

  return (
    <div className="chatWelcomeContainer w-full">
      <div className="h-[20px] sm:h-[32px] w-full"></div>
      <div className="flex">
        <Avatar className="mr-[12px] hidden sm:block flex-shrink-0" src={viteOutputObj === 'inner' ? AIIcon : AvatarBot} />
        <motion.div
          className="sm:ml-[20px] rounded-[20px] box-border px-[16px] py-[16px] sm:px-[24px] sm:py-[20px]"
          style={{ background: '#F7FAFD' }}
        >
          <div className="content">
            <p
              className="font-medium text-[#333]"
              style={{ fontSize: '16px' }}
            >
              {getWelcomeText()}
            </p>
            {/* <p className="text-[15px] mt-[4px]  sm:mt-[8px] sm:text-13px text-[#27353C] font-300">作为您的智能保险伙伴，您有各类专业相关的问题都可以抛给我哟~让我们互相帮助共同成长吧~</p> */}
          </div>
        </motion.div>
      </div>
      <div className="h-[20px] sm:h-[32px] w-full"></div>
    </div>
  )
}
