import React from 'react'
import ReactDOM from 'react-dom/client'
import { BrowserRouter } from 'react-router-dom'
import { NextUIProvider } from '@nextui-org/react'
import App from './App'
import './styles/index.less'

const rootEl = document.getElementById('root')

document.documentElement.classList.add('light')

if (rootEl) {
  const root = ReactDOM.createRoot(rootEl)
  root.render(
    <React.StrictMode>
      <NextUIProvider>
        <BrowserRouter>
          <main>
            <App />
          </main>
        </BrowserRouter>
      </NextUIProvider>
    </React.StrictMode>,
  )
}
