import http from '@/utils/request'

/**
 * 查询用户历史会话列表
 * @params
 */
export function fetchQueryUserConversationPage<T>(data: T) {
  return http.post('/conversation/api/conversation/mobile/v1/query_user_conversation_page', data)
}

/**
 * 创建会话
 * @params { * }
 */
export function fetchCreateConversation<T>(data: T) {
  return http.post('/conversation/api/conversation/mobile/v1/create_conversation', data as Record<string, any>)
}

/**
 * 查询用户问答历史
 * @params { * }
 */
export function fetchUserQaRecordPage(conversationId: string, toolId?: string) {
  return http.post('/conversation/api/conversation/mobile/v1/query_user_qa_record_list', { conversationId, toolId: toolId || '' })
}

/**
 * 删除用户历史会话
 * @params
 */
export function fetchDeleteUserConversation(conversationIdList: string[]) {
  return http.post('/conversation/api/conversation/mobile/v1/delete_user_conversation', {
    conversationIdList,
  })
}

/**
 * 获取历史会话ID
 * @params
 */
export function fetchSessionConversationId<T>(data: T) {
  const requestData = {
    ...(data as Record<string, any>),
    busiType: '01',
    busiId: (data as Record<string, any>)?.busiId || '',
  }
  return http.post('/conversation/api/conversation/mobile/v1/get_user_conversation_session', requestData)
}
