import type React from 'react'
import { Avatar } from '@heroui/react'
import { motion } from 'framer-motion'
import { useSearchParams } from 'react-router-dom'
import AvatarBot from '@/assets/avatarBot.png'
import AIIcon from '@/assets/ai-icon.png'

interface TacticsWelcomeProps {
  cleared?: boolean
}

export const TacticsWelcome: React.FC<TacticsWelcomeProps> = ({ cleared }) => {
  const viteOutputObj = import.meta.env.VITE_OUTPUT_OBJ || 'open'
  const [searchParams] = useSearchParams()
  const from = searchParams.get('from')
  const place = searchParams.get('place')
  const isOrderPlace = from === 'tactics' && place === 'order'

  const welcomeText = cleared
    ? '暂无分析记录，点击右上方按钮开始新的分析吧!'
    : isOrderPlace
      ? '正在为您分析工单数据，请耐心等待一会哦～'
      : '正在为您生成分析报告，请耐心等待一会哦～'

  return (
    <div className="chatWelcomeContainer w-full">
      <div className="h-[8px] sm:h-[16px] w-full"></div>
      <div className="flex items-start">
        <Avatar className="mr-[12px] flex-shrink-0" src={viteOutputObj === 'inner' ? AIIcon : AvatarBot} />
        <motion.div
          className="rounded-[20px] box-border px-[16px] py-[16px] sm:px-[24px] sm:py-[20px]"
          style={{ background: '#F7FAFD' }}
        >
          <div className="content">
            <p
              className="font-medium text-[#333]"
              style={{ fontSize: '16px' }}
            >
              {welcomeText}
            </p>
          </div>
        </motion.div>
      </div>
      <div className="h-[12px] sm:h-[24px] w-full"></div>
    </div>
  )
}
