// 格式化日期
export function formatDate(time: any) {
  const Dates = new Date(time);
  const year: number = Dates.getFullYear();
  const month: any = Dates.getMonth() + 1 < 10 ? `0${Dates.getMonth() + 1}` : Dates.getMonth() + 1;
  const day: any = Dates.getDate() < 10 ? `0${Dates.getDate()}` : Dates.getDate();
  return `${year}-${month}-${day}`;
}

// 格式化当前时间YY-MM-DD HH:MM:SS
export function formatDateTime(time: number) {
  const D = new Date(time);
  const yy = D.getFullYear();
  const MM = D.getMonth() + 1 < 10 ? `0${D.getMonth() + 1}` : D.getMonth() + 1;
  const dd = D.getDate() < 10 ? `0${D.getDate()}` : D.getDate();
  const HH = D.getHours() < 10 ? `0${D.getHours()}` : D.getHours();
  const mm = D.getMinutes() < 10 ? `0${D.getMinutes()}` : D.getMinutes();
  const ss = D.getSeconds() < 10 ? `0${D.getSeconds()}` : D.getSeconds();
  return `${yy}-${MM}-${dd} ${HH}:${mm}:${ss}`;
}
