/** 发现模块 */
declare namespace Discover {
  /** banner基类 */
  interface BannerBase {
    /** banner名称 */
    bannerName: string;
    /** banner状态 */
    bannerStatus: string | null;
  }
  /** banner列表查询 */
  interface BannerListQuery extends BannerBase {
    /** 更新时间-end */
    endUpdateTime: string;
    /** 更新时间-start */
    startUpdateTime: string;
    /** 是否置顶 */
    topFlag: number | null;
  }
  /** banner列表行类型 */
  interface BannerListRow extends BannerBase {
    bannerId: string;
    bannerImg: string;
    bannerType: string;
    createBy: string;
    createTime: string;
    feedId: string;
    finderUserName: string;
    groupId: number;
    linkUrl: string;
    scene: string;
    showOrder: number;
    updateBy: string;
    updateTime: string;
  }
  type BannerType = 'article' | 'video' | 'miniprogram' | 'none';
  type BannerScene = 'home' | 'find';
  /** banner表单 */
  interface BannerForm extends Pick<BannerBase, 'bannerName'> {
    /** 图片地址	 */
    bannerImg: string;
    /** 名称	 */
    bannerName: string;
    /** 跳转类型	 */
    bannerType: BannerType;
    /** 视频id	 */
    feedId: string;
    /** 视频号id	 */
    finderUserName: string;
    /** 跳转地址	 */
    linkUrl: string;
    /** 场景	 */
    scene: BannerScene;
  }

  /** 视频基类 */
  interface VideoBase {
    /** 名称 */
    title: string;
    /** 状态 */
    videoStatus: string | null;
    /** 栏目分类 */
    firstTypeId: string | null;
    /** 栏目子类 */
    secondTypeId: string | null;
  }

  /** video列表查询 */

  interface VideoListQuery extends VideoBase {
    /** 更新时间-end */
    endUpdateTime: string;
    /** 更新时间-start */
    startUpdateTime: string;
    topFlag: number | null;
    homeFlag: number | null;
  }
  /** video列表行类型 */
  interface VideoListRow extends VideoBase {
    /** f封面 */
    coverImg: string;
    /** 操作人 */
    createBy: string;
    createTime: string;
    feedId: string;
    finderUserName: string;
    /** 页面位置 */
    firstTypeName: string;
    horizontalCoverImg: string;
    linkUrl: string;
    /** 栏目分类 */
    secondTypeName: string;
    showOrder: number;
    updateBy: string;
    /** 更新时间 */
    updateTime: string;
    verticalCoverImg: string;
    videoId: string;
    videoLabel: string;
  }
  /** 视频表单 */
  interface VideoForm extends Omit<VideoBase, 'videoStatus'> {
    /** 封面 */
    coverImg: string;
    /** 封面图-宽屏 */
    horizontalCoverImg?: string;
    /** 封面图-竖屏 */
    verticalCoverImg?: string;
    /** 排序 */
    showOrder: number;
    /** 视频号id */
    finderUserName: string;
    /** 视频id */
    feedId: string;
    /** 是否显示标题 */
    showTitleFlag: boolean;
    homeFlag: boolean;
  }

  /** 资讯基类 */
  interface ArticleBase {
    articleStatus: string | null;
  }
  interface ArticleListQuery extends ArticleBase, Omit<VideoListQuery, 'videoStatus'> {
    hotFlag: number | null;
    homeFlag: number | null;
  }
  /** article列表行类型 */
  interface articleListRow extends ArticleBase {
    articleId: number;
    articleLabel: string;
    articleStatus: string;
    content: string;
    coverImg: string;
    createBy: string;
    createTime: string;
    firstTypeId: number;
    firstTypeName: string;
    linkUrl: string;
    secondTypeId: number;
    secondTypeName: string;
    showOrder: number;
    title: string;
    updateBy: string;
    updateTime: string;
  }

  /** article变淡 */
  interface ArticleForm extends Omit<ArticleBase, 'articleStatus'> {
    coverImg: string;
    firstTypeId: null | string;
    linkUrl: string;
    secondTypeId: null | string;
    homeFlag: boolean;
    title: string;
    showOrder: number;
  }
}
