import type { Router, RouteLocationNormalized, NavigationGuardNext } from 'vue-router';
import { routeName } from '@/router';
import { exeStrategyActions, getToken, setToken } from '@/utils';
import { fetchWxLogin } from '@/service/api/auth';
import { createDynamicRouteGuard } from './dynamic';
/** 处理路由页面的权限 */
export async function createPermissionGuard(
  to: RouteLocationNormalized,
  from: RouteLocationNormalized,
  next: NavigationGuardNext,
  router: Router
) {
  if (to.query.code && to.query.appid) {
    wwLogin(to, from, next, router);
    return;
  }
  // 动态路由
  const permission = await createDynamicRouteGuard(to, from, next, router);
  if (!permission) return;

  // 外链路由, 从新标签打开，返回上一个路由
  if (to.meta.href) {
    window.open(to.meta.href);
    next({ path: from.fullPath, replace: true, query: from.query });
    return;
  }

  const isLogin = Boolean(getToken());
  const needLogin = Boolean(to.meta?.requiresAuth);
  const hasPermission = true;
  const actions: Common.StrategyAction[] = [
    // 已登录状态跳转登录页，跳转至首页
    [
      isLogin && to.name === routeName('login'),
      () => {
        next({ name: routeName('root') });
      }
    ],
    // 不需要登录权限的页面直接通行
    [
      !needLogin,
      () => {
        next();
      }
    ],
    // 未登录状态进入需要登录权限的页面
    [
      !isLogin && needLogin,
      () => {
        next({ name: routeName('login') });
      }
    ],
    // 登录状态进入需要登录权限的页面，有权限直接通行
    [
      isLogin && needLogin && hasPermission,
      () => {
        next();
      }
    ],
    [
      // 登录状态进入需要登录权限的页面，无权限，重定向到无权限页面
      isLogin && needLogin && !hasPermission,
      () => {
        next({ name: routeName('no-permission') });
      }
    ]
  ];

  exeStrategyActions(actions);
}

async function wwLogin(
  to: RouteLocationNormalized,
  from: RouteLocationNormalized,
  next: NavigationGuardNext,
  router: Router
) {
  try {
    console.log(to, from, router, 'routerrouterrouter');
    const res = await fetchWxLogin(to.query.code as string);
    console.log(res, 'code登录页结果');
    if (res.data?.ok) {
      setToken(res.data.data.token);
      window.location.href = '/';
    } else {
      window.alert('企微登录失败');
      window.location.href = '/login';
    }
  } catch (error) {
    window.alert('企微登录失败');
    window.location.href = '/login';
  }
}
