/** 客户模块 */
declare namespace Customer {
  /** 客户列表搜索 */
  interface CustomerBase {
    realName: string; // 姓名
  }

  /** 客户列表 */
  interface CustomerListRow extends CustomerBase {
    realName: string; // 姓名
    userId: number; // 用户ID
    mobile: string; // 手机号
    idCard: string; // 身份证号
  }

  interface CustomerDetail extends CustomerBase {
    realName: string; // 姓名
    birthday: string; // 生日
    eduName: string; // 学历
    idCard: string; // 身份证号
    joinWorkTime: string; // 参加工作时间
    liveCityName: string; // 居住地
    mobile: string; // 手机号
    professionName: string; // 职业
    retireAge: number; // 年龄
    salary: string; // 工资
    sex: number; // 性别 0 男 1 女
    userId: string; // 用户id
  }

  interface CustomerCalculationListRow {
    calculationId: string; // 测算id
    calculationType: string; // 测算类型
    createTime: string; // 测算时间
    calculationParam: any; // 测算参数
    calculationResult: any; // 测算结果
  }

  interface CustomerCalculationListQuery {
    beginDate: string;
    calculationType: string;
    endDate: string;
    userId: string;
  }
}
