import { request } from '../request';

/**
 * 查询vip订单列表
 */
export function fetchQueryVipOrderList(params: Customer.CustomerBase) {
  return request.post(`/order/pc/v1/query_vip_order_page`, params);
}

/**
 * 查询 问宠医 订单列表
 */
export function fetchQueryHumanDoctorOrderList(params: Customer.CustomerBase) {
  return request.post(`/order/pc/v1/query_doctor_order_page`, params);
}

/**
 * 更新 问宠医 订单状态
 */
export function fetchUpdateHumanDoctorOrderStatus<T>(params: T) {
  return request.post(`/order/pc/v1/update_order`, params);
}


/**
 * 查询 问宠医 订单详情
 */
export function fetchQueryHumanDoctorOrderDetail<T>(params: T) {
  return request.post(`/order/pc/v1/get_doctor_order_detail`, params);
}

/**
 * 查询 问宠医 订单流转
 */
export function fetchQueryHumanDoctorOrderRecord<T>(params: T) {
  return request.post(`/order/pc/v1/query_order_record_list`, params);
}

/**
 * 查询 支付宝实物 订单列表
 */
export function fetchQueryAlipayOrderList(params: Customer.CustomerBase) {
  return request.post(`/order/pc/v1/query_product_order_page`, params);
}

export function fetchDownloadOrderTemplate() {
  return request.post(`/order/pc/v1/download_product_order_template`, {}, {
    responseType: 'blob'
  });
}

export function fetchDownloadOrders<T>(params: T) {
  return request.post(`/order/pc/v1/download_product_order`, params, {
    responseType: 'blob'
  });
}

export function fetchUploadOrderExpressInfo<T>(fm: T) {
  return request.post(`/order/pc/v1/upload_product_order`, fm);
}
