import { request } from '../request';

/**
 * 文档列表
 */
export function fetchQueryDocList<T>(params: T) {
  return request.post(`/product/pc/v1/docSet/query_document_list`, params);
}

/**
 * 新增 文档集文档
 */
export function fetchAddSetDoc<T>(params: T) {
  return request.post(`/product/pc/v1/docSet/add_document`, params);
}

/**
 * 新增 文档集文档
 */
export function fetchUpdateSetDoc<T>(params: T) {
  return request.post(`/product/pc/v1/docSet/update_document`, params);
}

/**
 * 删除 文档集文档
 */
export function fetchDeleteSetDoc<T>(params: T) {
  return request.post(`/product/pc/v1/docSet/delete_document`, params);
}

/**
 * 提交 文档集文档
 */
export function fetchSubmitSetDoc<T>(params: T) {
  return request.post(`/product/pc/v1/docSet/submit_document`, params);
}

/**
 * 审核 文档
 */
export function fetchAuditSetDoc<T>(params: T) {
  return request.post(`/product/pc/v1/docSet/audit_document`, params);
}

/**
 * 撤回解析 文档集文档
 */
export function fetchBackOffSetDoc<T>(params: T) {
  return request.post(`/product/pc/v1/docSet/analysis_backOff_document`, params);
}

/**
 * 重新解析 文档集文档
 */
export function fetchAnalysisSetDoc<T>(params: T) {
  return request.post(`/product/pc/v1/docSet/analysis_document`, params);
}

/**
 * 文档集列表
 */
export function fetchGetDocSetList<T>(params: T) {
  return request.post(`/product/pc/v1/docSet/query_documentSet_list`, params);
}
