export default function useImport() {
  function importFileOfXSL(el: any) {
    const elDom = el;
    return new Promise(resolve => {
      elDom.click();
      elDom.addEventListener('change', () => {
        const files = [...elDom.files];
        files.forEach(async file => {
          const isAccept = file.type === 'application/vnd.ms-excel';
          if (!isAccept) {
            window.$message?.error(`${file.name} 格式有误！`);
            resolve(false);
            return;
          }
          resolve(file);
        });
      });
    });
  }
  return {
    importFileOfXSL
  };
}
