import { EnumStorageKey } from '@/enum';
import { getLocal } from '@/utils';

export default function useAuth() {
  function handlePermission(el: any, binding: any) {
    const permissions: string[] = getLocal(EnumStorageKey.permissions) as string[];
    if (permissions.length === 1 && permissions[0] === '*') {
      return true;
    }
    const result = permissions.some(p => p === (el ? binding.value : binding));
    if (!result && el) el.remove();
    return result;
  }
  return {
    handlePermission
  };
}
