/** 手机号码正则 */
export const REGEXP_PHONE =
  /^[1](([3][0-9])|([4][0,1,4-9])|([5][0-3,5-9])|([6][2,5,6,7])|([7][0-8])|([8][0-9])|([9][0-3,5-9]))[0-9]{8}$/;

/** 邮箱正则 */
export const REGEXP_EMAIL = /^\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/;

/** 密码正则(密码为8-18位数字/字符/符号的组合) */
export const REGEXP_PWD =
  /^(?![0-9]+$)(?![a-z]+$)(?![A-Z]+$)(?!([^(0-9a-zA-Z)]|[()])+$)(?!^.*[\u4E00-\u9FA5].*$)([^(0-9a-zA-Z)]|[()]|[a-z]|[A-Z]|[0-9]){8,18}$/;

/** 6位数字验证码正则 */
export const REGEXP_CODE_SIX = /^\d{6}$/;

/** 4位数字验证码正则 */
export const REGEXP_CODE_FOUR = /^\d{4}$/;

/** url链接正则 */
export const REGEXP_URL =
  /(((^https?:(?:\/\/)?)(?:[-;:&=+$,\w]+@)?[A-Za-z0-9.-]+(?::\d+)?|(?:www.|[-;:&=+$,\w]+@)[A-Za-z0-9.-]+)((?:\/[+~%/.\w-_]*)?\??(?:[-+=&;%@.\w_]*)#?(?:[\w]*))?)$/;

/** 判断是否是数字正则 */
export const REGEXP_IS_NUMBER = /^\d+(\.\d+)?$/;

/** 判断是否是正整数正则 */
export const REGEXP_IS_INTEGER = /^[1-9]+\d*$/;

/** 判断是否是中文、英文、空格正则 */
export const REGEXP_IS_CN_EN = /^[\u4e00-\u9fa5a-zA-Z\s]*$/;

/** 判断是否是中文、英文、空格、数字正则 */
export const REGEXP_IS_CN_EN_NUMBER = /^[\u4e00-\u9fa5a-zA-Z0-9\s]*$/;

/** 判断是否是中文、空格正则 */
export const REGEXP_IS_CN = /^[\u4e00-\u9fa5\s]*$/;

/** 判断是否是英文、空格正则 */
export const REGEXP_IS_EN = /^[a-zA-Z\s]*$/;
