/** 请求环境配置 */
type ServiceEnv = Record<
  EnvType,
  {
    // /** 请求地址 */
    url?: string;
    /** 代理地址 */
    proxy: string;
  }
>;

/** 环境配置 */
const serviceEnvConfig: ServiceEnv = {
  dev: {
    url: 'http://82.156.138.187:19001/sdream-api/manager/api', // 本地调试打开
    proxy: '/api'
  },
  sit: {
    url: 'http://82.156.138.187:19001/sdream-api/manager/api', // 本地调试打开
    proxy: ''
  },
  uat: {
    // url: 'https://uat-lfsplanning-platform.guominpension.com/manager/api', / 本地调试打开
    proxy: '/api'
  },
  pre: {
    // url: 'https://pre-lfsplanning-platform.guominpension.com/manager/api',/ 本地调试打开
    proxy: '/api'
  },
  prod: {
    url: 'http://82.156.138.187:19001/sdream-api/manager/api', // 本地调试打开
    proxy: ''
  }
};

/**
 * 获取环境配置
 * @param env 环境描述
 */
export function getEnvConfig(env: ImportMetaEnv) {
  const { VITE_ENV_TYPE = 'dev' } = env;
  const envConfig = {
    http: serviceEnvConfig[VITE_ENV_TYPE]
  };
  return envConfig;
}
