import apis from '@/apis'
import SessionStorageUtil from '@/utils/session'

class AuthUtil {
  static async auth(params: URLSearchParams): Promise<boolean> {
    if (process.env.REACT_APP_ENV === 'development') {
      SessionStorageUtil.setItem('__TOKEN__', '6d29e9d470e24cf9af48bd5881b97f80');
      return true;
    } else {
      const token = SessionStorageUtil.getItem('__TOKEN__');
      if (!token) {
        if (!params.get('code')) {
          try {
            const res = await apis.common.getLoginUrl();
            if (res.ok) {
              window.location.replace(res.data);
            }
          } catch (error) {
            throw error
          }
        } else {
          try {
            const res = await apis.common.login({
              code: params.get('code') || '',
              state: params.get('state') || '',
              amp: params.get('amp') || ''
            });
            if (res.ok) {
              SessionStorageUtil.setItem('__TOKEN__', res.data.token);
            }
          } catch (error) {
            throw error
          }
        }
      }
      return true;
    }
  }
}
export default AuthUtil
