import {type RsbuildConfig as BaseRsbuildConfig} from '@rsbuild/shared';
import {defineConfig} from '@rsbuild/core';
import merge from 'lodash/merge';
import buildBaseConfig from "./build.base";
import {ENV_CONFIG, ENV_TEST} from "../config";
function defineConfigCreator(): BaseRsbuildConfig {
    const testEnvConfig = ENV_CONFIG[ENV_TEST];

    for (const prodEnvConfigKey in testEnvConfig) {
        process.env[prodEnvConfigKey] = testEnvConfig[prodEnvConfigKey as keyof typeof testEnvConfig]
    }

    const testBuildConfig: BaseRsbuildConfig = {
        source: {
            define: {
                'process.env.REACT_APP_ENV': JSON.stringify(ENV_TEST),
                'process.env.REACT_APP_API_URL': JSON.stringify(testEnvConfig.REACT_APP_API_URL)
            }}
    }

    return defineConfig(merge({}, buildBaseConfig, testBuildConfig))
}
export default defineConfigCreator();
