import {type RsbuildConfig as BaseRsbuildConfig} from '@rsbuild/shared';
import {defineConfig} from '@rsbuild/core';
import merge from 'lodash/merge';
import buildBaseConfig from "./build.base";
import {ENV_CONFIG, ENV_PROD} from "../config";
function defineConfigCreator(): BaseRsbuildConfig {
    const prodEnvConfig = ENV_CONFIG[ENV_PROD];

    for (const prodEnvConfigKey in prodEnvConfig) {
        process.env[prodEnvConfigKey] = prodEnvConfig[prodEnvConfigKey as keyof typeof prodEnvConfig]
    }

    const prodBuildConfig: BaseRsbuildConfig = {
        output: { disableSourceMap: true },
        performance: {removeConsole: ['log', 'warn'],},
        source: {
            define: {
                'process.env.REACT_APP_ENV': JSON.stringify(ENV_PROD),
                'process.env.REACT_APP_API_URL': JSON.stringify(prodEnvConfig.REACT_APP_API_URL)
            }},
    }

    return defineConfig(merge({}, buildBaseConfig, prodBuildConfig))
}
export default defineConfigCreator();
