import axios, { type AxiosInstance, type InternalAxiosRequestConfig, type AxiosResponse } from 'axios'
import SessionStorageUtil from '@/utils/session'
import { Toast } from '@nutui/nutui-react'

const axiosInstance: AxiosInstance = axios.create({
  baseURL: process.env.REACT_APP_API_URL,
  timeout: 30000
})
axiosInstance.interceptors.request.use(
  (config: InternalAxiosRequestConfig): InternalAxiosRequestConfig => {
    config.headers.token = SessionStorageUtil.getItem('__TOKEN__')
    return config
  },
  async (error) => {
    return await Promise.reject(error)
  }
)

axiosInstance.interceptors.response.use(
  (response: AxiosResponse): AxiosResponse => {
    // 处理登录失效
    if (response.data.code === 9999) {
      Toast.show('登录失效')
      setTimeout(() => {
        SessionStorageUtil.clear()
        window.location.replace('/')
      }, 2000)
    }
    return response
  },
  async (error) => {
    return await Promise.reject(error)
  }
)

export default axiosInstance
