import React, { useEffect, useState } from 'react'
import styles from './index.module.scss'
import { useNavigate, useSearchParams } from 'react-router-dom'
import HomeBg from '@/pages/Home/components/HomeBg'
import HomeContent from '@/pages/Home/components/HomeContent'
import AuthUtil from '@/utils/auth'
import OrderHelper from '@/pages/Home/helper/order'

const Home: React.FC = () => {
  const [params] = useSearchParams()
  const navigate = useNavigate()
  const [isAuthed, setIsAuthed] = useState(false)
  useEffect(() => {
    AuthUtil.auth(params)
      .then(res => {
        OrderHelper.queryUserOrder(navigate).then(() => {
          setIsAuthed(res)
        })
      })
  }, [])

  return (
        <div className={styles.wrap}>
            { isAuthed && <HomeBg /> }
            { isAuthed && <HomeContent /> }
        </div>
  )
}

export default Home
