import apis from '@/apis'
import { type CreateOrderRequestData } from '@/apis/common'
import { type NavigateFunction } from 'react-router-dom'

class OrderHelper {
  /**
     * 提交订单：
     *  1. 创建订单
     *  2. 查询支付地址
     *  3. 查询支付配置
     *  4. 唤起app支付
     * @param params CreateOrderRequestData
     */
  static async submitOrder (params: CreateOrderRequestData) {
    const createOrderRes = await apis.common.createOrder(params)
    const queryPayUrlRes = await apis.common.queryPayUrl({ orderId: createOrderRes.data })
    const tokenId = queryPayUrlRes.data.split('=')[1]
    const queryPayConfigRes = await apis.common.queryPayConfig<Record<'param', Record<string, string>>>()
    const data = queryPayConfigRes.data
    data.param.tokenId = tokenId
    window.AlipayJSBridge.call('startApp', data, function (result: string) {
      console.log(result, '支付结果')
    })
  }

  /**
     * 获取用户的订单
     */
  static async queryUserOrder (navigate: NavigateFunction) {
    const res = await apis.common.queryUserOrder()
    if (res.ok) {
      if (res.data?.lotteryOrderId) {
        navigate(`/lottery?lotteryOrderId=${res.data.lotteryOrderId}`, {
          replace: true
        })
      }
      if (res.data?.orderId) {
        navigate(`/orderDetail?orderId=${res.data.orderId}`, {
          replace: true
        })
      }
    }
  }
}

export default OrderHelper
