import {type RsbuildConfig as BaseRsbuildConfig} from '@rsbuild/shared';
import {defineConfig} from '@rsbuild/core';
import merge from 'lodash/merge';
import buildBaseConfig from "./build.base";
import {ENV_CONFIG, ENV_DEV} from "../config";
function defineConfigCreator(): BaseRsbuildConfig {
    const devEnvConfig = ENV_CONFIG[ENV_DEV];

    for (const prodEnvConfigKey in devEnvConfig) {
        process.env[prodEnvConfigKey] = devEnvConfig[prodEnvConfigKey as keyof typeof devEnvConfig]
    }

    const devBuildConfig: BaseRsbuildConfig = {
        source: {
            define: {
                'process.env.REACT_APP_ENV': JSON.stringify(ENV_DEV),
                'process.env.REACT_APP_API_URL': JSON.stringify(devEnvConfig.REACT_APP_API_URL)
            }},
        tools: { bundlerChain(chain, { env }) { chain.devtool('eval'); } }
    }

    return defineConfig(merge({}, buildBaseConfig, devBuildConfig))
}
export default defineConfigCreator();
