import React from "react";
import {type QueryMyPrizeListResponse} from "@/apis/common";
import styles from "@/pages/Lottery/index.module.scss";
import myPrizeHighLightImg from "@/assets/images/myPrizeHighLight.png";
import myPrizeDisabledImg from "@/assets/images/myPrizeDisabled.png";
import myPrizeUnclaimedImg from "@/assets/images/myPrizeUnclaimed.png";
import myPrizeReceivedImg from "@/assets/images/myPrizeReceived.png";
import myPrizeUsedImg from '@/assets/images/myPrizeUsed.png'
import {
    LOTTERY_ORDER_STATUS__EXPIRED, LOTTERY_ORDER_STATUS__FALL_IN_SEND,
    LOTTERY_ORDER_STATUS__RECEIVED,
    LOTTERY_ORDER_STATUS__UNCLAIMED, LOTTERY_ORDER_STATUS__USED,
    LOTTERY_PRIZE_VALUE_TYPE__POINT,
    LOTTERY_PRIZE_VALUE_TYPE__TICKET
} from "@/constants";
interface Props {
    item: QueryMyPrizeListResponse,
    onReceivePrize: (orderId: string) => Promise<void>
}

const MyPrizeItem: React.FC<Props> = ({item, onReceivePrize}) => {

    let statusSrc = "";
    if ([LOTTERY_ORDER_STATUS__UNCLAIMED, LOTTERY_ORDER_STATUS__FALL_IN_SEND].includes(item.orderStatus)) {
        statusSrc = myPrizeUnclaimedImg;
    } else if (item.orderStatus === LOTTERY_ORDER_STATUS__RECEIVED) {
        statusSrc = myPrizeReceivedImg;
    }

    let prizeItemBgSrc = "";
    if ([LOTTERY_ORDER_STATUS__EXPIRED].includes(item.orderStatus) ) {
        prizeItemBgSrc = myPrizeDisabledImg;
    } else if(item.orderStatus === LOTTERY_ORDER_STATUS__USED) {
        prizeItemBgSrc = myPrizeUsedImg;
    } else {
        prizeItemBgSrc = myPrizeHighLightImg;
    }

    return (
        <div className={styles.myPrizeItem}>
            <img className={styles.myPrizeItemBg} src={prizeItemBgSrc} alt=""/>
            {statusSrc && <img className={styles.myPrizeItemStatus} src={statusSrc} alt=""/>}
            <div className={styles.myPrizeItemPrice}>
                <div>¥<span>{item.prizeValue}</span></div>
                <span>
                    {item.prizeValueType === LOTTERY_PRIZE_VALUE_TYPE__TICKET && "立减金券"}
                    {item.prizeValueType === LOTTERY_PRIZE_VALUE_TYPE__POINT && "积分"}
                </span>
            </div>
            <div className={styles.myPrizeItemInfo}>
                <h3>{item.prizeName}</h3>
                <p>请于{item.receiveDeadlineTime}</p>
                <p>前完成领取</p>
            </div>
            {[LOTTERY_ORDER_STATUS__UNCLAIMED, LOTTERY_ORDER_STATUS__FALL_IN_SEND].includes(item.orderStatus) &&
                <div className={styles.myPrizeItemButton} onClick={() => onReceivePrize(item.orderId)}>去领取</div>}
        </div>
    );
};

export default MyPrizeItem;