import React from "react";
import styles from "@/pages/Home/index.module.scss";

interface HomeProductItemProps {
    /**
     * 背景图
     */
    bannerImg: string;
    /**
     * 标题
     */
    title: string;
    /**
     * 按钮文字
     */
    buttonText?: string;
    /**
     * 按钮文字颜色
     */
    buttonTextColor: string;
    /**
     * 点击
     */
    onButtonClick: (idx: number) => void;
    /**
     * 索引
     */
    idx: number;
}

const HomeProductItem: React.FC<HomeProductItemProps> = (props) => {
    const buttonStyle = {color: props.buttonTextColor};
    return (
        <div className={styles.productItem}>
            <img className={styles.productItemBg} src={props.bannerImg} alt={props.title}/>
            <h3 className={styles.productItemTitle}>{props.title}</h3>
            <div className={styles.productItemButton} style={buttonStyle} onClick={() => {
                props.onButtonClick(props.idx);
            }}>{props.buttonText || "立即购买"}</div>
        </div>
    );
};

export default HomeProductItem;
