/**
 * 创建px2vw
 */
export const postcssPxToViewportCreator = function() {
    const postcssPxToViewport = require('postcss-px-to-viewport')
    return postcssPxToViewport({
        unitToConvert: 'px', // 要转化的单位
        viewportWidth: 375,
        viewportUnit: 'vw', // 指定需要转换成的视窗单位，建议使用 rem
        fontViewportUnit: 'vw', // 字体使用的视口单位
        unitPrecision: 13, // 指定`px`转换为视窗单位值的小数后 x位数
        propList: ['*'], // 指定转换的css属性的单位，*代表全部css属性的单位都进行转换
        selectorBlackList: ['ignore'], // 指定不转换为视窗单位的类名，
        minPixelValue: 1, // 默认值1，小于或等于1px则不进行转换
        mediaQuery: true, // 是否在媒体查询的css代码中也进行转换，默认false
        replace: true, // 是否转换后直接更换属性值
        exclude: [/node_modules/], // 设置忽略文件，用正则做目录名匹配
        landscape: false, // 是否处理横屏情况
    })
}