import axiosInstance from '@/utils/axios'
/**
 * 获取登录地址
 */
export const getLoginUrl = async (): Promise<BackendResponse<string>> => {
  try {
    const response = await axiosInstance.get<BackendResponse<string>>('/api/login/get_login_url')
    return response.data
  } catch (error) {
    throw error
  }
}

interface LoginRequestData {
  code: string
  state: string
  amp: string
}

interface LoginResponseData {
  token: string
}

/**
 * 登录
 * @returns Promise<LoginResponseData>
 * @param requestData
 */
export const login = async (requestData: LoginRequestData): Promise<BackendResponse<LoginResponseData>> => {
  try {
    const response = await axiosInstance.post<BackendResponse<LoginResponseData>>('/api/login/authorize', requestData)
    return response.data
  } catch (error) {
    throw error
  }
}

interface QueryUserOrderResponse {
  orderId: string
  lotteryOrderId: string
}

export const queryUserOrder = async (): Promise<BackendResponse<QueryUserOrderResponse>> => {
  try {
    const response = await axiosInstance.get<BackendResponse<QueryUserOrderResponse>>('/api/order/getUserOrder')
    return response.data
  } catch (error) {
    throw error
  }
}

export interface QueryBranchListResponseData {
  branchCode: string
  branchName: string
  showOrder: 1
}

/**
 * 获取网点列表
 */
export const queryBranchList = async (): Promise<BackendResponse<QueryBranchListResponseData[]>> => {
  try {
    const response = await axiosInstance.get<BackendResponse<QueryBranchListResponseData[]>>('/api/branch/query_list')
    return response.data
  } catch (error) {
    throw error
  }
}

export interface CreateOrderRequestData {
  branchName: string
  branchCode: string
  productCode: string
  number: number
}

/**
 * 创建订单
 * @param requestData
 */
export const createOrder = async (requestData: CreateOrderRequestData): Promise<BackendResponse<string>> => {
  try {
    const response = await axiosInstance.post<BackendResponse<string>>('/api/order/create_order', requestData)
    return response.data
  }catch (error) {
    throw error;
  }
}

interface GetPayUrlRequestData {
  orderId: string
}

/**
 * 查询支付地址
 * @param requestData
 */
export const queryPayUrl = async (requestData: GetPayUrlRequestData): Promise<BackendResponse<string>> => {
  try {
    const response = await axiosInstance.post<BackendResponse<string>>('/api/pay', requestData)
    return response.data
  } catch (error) {
    throw error;
  }
}

/**
 * 查询支付配置
 */
export const queryPayConfig = async <T>(): Promise<BackendResponse<T>> => {
  try {
    const response = await axiosInstance.get<BackendResponse<T>>('/api/pay/pay_config');
    return response.data;
  } catch (error) {
    throw error;
  }
}


interface QueryOrderInfoResponseOrderDetail {
  branchCode: string
  branchName: string
  mobile: string
  orderAmount: string
  payStatus: string
  payTime: string
}

interface QueryOrderInfoResponseProductDetailInfo {
  productCode: string
  productName: string
}

export interface QueryOrderInfoResponse {
  orderDetail: QueryOrderInfoResponseOrderDetail
  productDetailInfo: QueryOrderInfoResponseProductDetailInfo
}

/**
 * 查询订单详情
 * @param orderId
 */
export const queryOrderInfo = async (orderId: string): Promise<BackendResponse<QueryOrderInfoResponse>> => {
  try {
    const response = await axiosInstance.get<BackendResponse<QueryOrderInfoResponse>>(`/api/order/detail/${orderId}`)
    return response.data
  } catch (error) {
    throw error
  }
}
