import { type RsbuildConfig as BaseRsbuildConfig } from '@rsbuild/shared';

type HtmlTemplateType = BaseRsbuildConfig['html']

export const HTML_TEMPLATE_CONFIG:HtmlTemplateType = {
    title: 'test',
    favicon: './static/favicon.ico',
    tags: [
        { tag: 'meta', attrs: { charset: 'UTF-8'} },
        { tag: 'meta', attrs: { name: 'viewport', content: 'width=device-width, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0, viewport-fit=cover'} },
        { tag: 'meta', attrs: { 'http-equiv': 'X-UA-Compatible', content: 'IE=edge,chrome=1'} },
        { tag: 'meta', attrs: { 'http-equiv': 'Expires', content: '0' }},
        { tag: 'meta', attrs: { 'http-equiv': 'Pragma', content: 'no-cache' }},
        { tag: 'meta', attrs: { 'http-equiv': 'Cache-control', content: 'no-cache' }},
        { tag: 'meta', attrs: { 'http-equiv': 'Cache', content: 'no-cache' }},
    ]
}