import { type RsbuildConfig as BaseRsbuildConfig } from '@rsbuild/shared';
import { pluginReact } from '@rsbuild/plugin-react';
import { CSS_MODULES_LOCAL_IDENT_NAME, HTML_TEMPLATE_CONFIG } from '../config'
import { postcssPxToViewportCreator } from '../plugins'

const buildBaseConfig: BaseRsbuildConfig = {
    plugins: [pluginReact()],
    output: {
        enableCssModuleTSDeclaration: true,
        cssModules: {
            localIdentName: CSS_MODULES_LOCAL_IDENT_NAME
        }
    },
    html: HTML_TEMPLATE_CONFIG,
    tools: {
        postcss: (opts) => {
            opts.postcssOptions?.plugins?.push(postcssPxToViewportCreator())
        },
    },
    performance: {
        chunkSplit: {
            strategy: 'split-by-experience'
        }
    },
    server: {
        port: 3000
    }
}

export default buildBaseConfig
