class LocalStorageUtil {
    /**
     * 存储数据到localStorage
     * @param key 键名
     * @param value 值，将被自动转换为字符串
     */
    static setItem <T>(key: string, value: T): void {
        const stringValue = JSON.stringify(value)
        localStorage.setItem(key, stringValue)
    }

    /**
     * 从localStorage获取数据
     * @param key 键名
     * @returns 返回解析后的值，如果不存在则返回null
     */
    static getItem<T>(key: string): T | null {
        const item = localStorage.getItem(key)
        if (item === null) {
            return null
        }
        try {
            return JSON.parse(item) as T
        } catch (e) {
            console.error('Error parsing localStorage item', e)
            return null
        }
    }

    /**
     * 从localStorage中删除特定数据
     * @param key 键名
     */
    static removeItem (key: string): void {
        localStorage.removeItem(key)
    }

    /**
     * 更新localStorage中的数据
     * @param key 键名
     * @param value 新的值，将被自动转换为字符串
     */
    static updateItem <T>(key: string, value: T): void {
        this.setItem(key, value)
    }

    /**
     * 清除所有localStorage数据
     */
    static clear (): void {
        localStorage.clear()
    }
}

export default LocalStorageUtil
