import React, {useState} from 'react'
import styles from './index.module.scss'
import lotteryWrapBgImg from '@/assets/images/lotteryWrapBg.png'
import lotteryPrizeImg from '@/assets/images/lotteryPrize.png'
import lotteryButtonBgImg from '@/assets/images/lotteryButtonBg.png'
import lotteryRuleTitleBgImg from '@/assets/images/lotteryRuleTitleBg.png'
import myPrizeHighLightImg from '@/assets/images/myPrizeHighLight.png'
import myPrizeUnclaimedImg from '@/assets/images/myPrizeUnclaimed.png'
import winningLotteryImg from '@/assets/images/winningLottery.png'
import { Popup, Overlay } from '@nutui/nutui-react';

const Lottery: React.FC = () => {
    const [showMyPrizePopup, setShowMyPrizePopup] = useState(false);

    const [visible, setVisible] = useState(false)

    interface LotteryConfig {
        prizeCount: number;
        drawCount: number;
        drawIndex: number;
        rotating: number;
        round: number;
        duration: number;
        running: boolean;
    }

    const [lotteryConfig, setLotteryConfig] = useState<LotteryConfig>({
        prizeCount: 0, // 商品个数 - 服务端获取商品数量
        drawCount: 1, // 第几次抽奖 - 从第一次开始
        drawIndex: 0, // 中奖索引 - 顺时针排序 - 服务端获取获奖索引
        rotating: 0, // 动画旋转角度
        round: 5, // 旋转圈数
        duration: 3000, // 动画持续时间
        running: false // 锁定抽奖状态
    })

    const [lotteryStyle, setLotteryStyle] = useState({
        transform: '',
        transition: '',
        WebkitTransform: '',
        WebkitTransition: ''
    })

    function onClickLotteryButton() {
        console.log(lotteryConfig,'lotteryConfig')
        setLotteryConfig(prevConfig => {
            // 如果正在运行，则不进行任何操作
            if (prevConfig.running) return prevConfig;

            // 更新状态
            const newConfig = {
                ...prevConfig,
                running: true,
                prizeCount: 5, // 假设这些值是从服务器获取的
                drawIndex: 4,
                drawCount: prevConfig.drawCount + 1
            } as LotteryConfig;

            newConfig.rotating = newConfig.round * 360 * newConfig.drawCount - (newConfig.drawIndex + 1) * (360 / newConfig.prizeCount) + 36;

            // 更新旋转样式
            setLotteryStyle({
                transform: `rotate(${newConfig.rotating}deg)`,
                transition: `transform ${newConfig.duration}ms ease-in-out`,
                WebkitTransform: `rotate(${newConfig.rotating}deg)`,
                WebkitTransition: `transform ${newConfig.duration}ms ease-in-out`
            });

            // 在动画结束后解锁
            setTimeout(() => {
                setLotteryConfig(prev => ({ ...prev, running: false }));
                setVisible(true)
            }, newConfig.duration);

            return newConfig;
        });
    }

    return (
        <div className={styles.wrap}>
            <div className={styles.lotteryWrap}>
                <img className={styles.lotteryWrapBgImg} src={lotteryWrapBgImg} alt=""/>
                <img style={lotteryStyle} className={styles.lotteryPrizeBgImg} src={lotteryPrizeImg} alt=""/>
                <img className={styles.lotteryButtonBgImg} onClick={onClickLotteryButton} src={lotteryButtonBgImg} alt=""/>
                <div className={styles.lotteryMyPrizeButton} onClick={() => setShowMyPrizePopup(true)}>我的奖品</div>
            </div>
            <img className={styles.lotteryRuleTitleBg} src={lotteryRuleTitleBgImg} alt=""/>
            <div className={styles.lotteryRuleContent}>
                <div className={styles.lotteryRuleItem}><span></span> 该活动仅供掌银新客选择（线下礼品、线上微信立减金抽奖二选一），</div>
                <div className={styles.lotteryRuleItem}><span></span> 每季度每个客户号仅可参与其中一项。</div>
            </div>

            {/*我的奖品*/}
            <Popup
                closeable
                visible={ showMyPrizePopup }
                style={{ height: '454px' }}
                position="bottom"
                round
                onClose={ () => { setShowMyPrizePopup(false) } }
            >
                <div className={styles.myPrizePopupWrap}>
                    <div className={styles.myPrizePopupTitle}>我的奖品</div>
                    <div className={styles.myPrizePopupContent}>
                        <MyPrizeItem />
                        <MyPrizeItem />
                        <MyPrizeItem />
                        <MyPrizeItem />
                        <MyPrizeItem />
                        <MyPrizeItem />
                        <MyPrizeItem />
                    </div>
                </div>
            </Popup>
            {/*我的奖品*/}


            {/*中奖弹窗*/}
            <Overlay visible={visible} closeOnOverlayClick={false}>
                <div className={styles.winningLotteryWrap}>
                    <div className={styles.winningLotteryInner}>
                        <div className={styles.winningLotteryTitle}>您获得 <span>5.55元微信立减金</span></div>
                        <img src={winningLotteryImg} alt=""/>
                        <div className={styles.winningLotteryTime}>请于2023.11.30 23:59:59前完成领取</div>
                        <div className={styles.winningLotteryClose} onClick={() => setVisible(false)}></div>
                        <div className={styles.winningLotteryConfirm} onClick={() => setVisible(false)}></div>
                    </div>
                </div>
            </Overlay>
            {/*中奖弹窗*/}
        </div>
  )
}

const MyPrizeItem: React.FC = () => {
    return (
        <div className={styles.myPrizeItem}>
            <img className={styles.myPrizeItemBg} src={myPrizeHighLightImg} alt=""/>
            <img className={styles.myPrizeItemStatus} src={myPrizeUnclaimedImg} alt=""/>
            <div className={styles.myPrizeItemPrice}>
                <div>¥<span>58.88</span></div>
                <span>立减金券</span>
            </div>
            <div className={styles.myPrizeItemInfo}>
                <h3>58.88元立减金券</h3>
                <p>请于2023.11.30 23:59:59</p>
                <p>前完成领取</p>
            </div>
            <div className={styles.myPrizeItemButton}>去领取</div>
        </div>
    )
}

export default Lottery
