import React, { useEffect, useState } from 'react'
import styles from './index.module.scss'
import { useNavigate, useSearchParams } from 'react-router-dom'
import HomeBg from '@/pages/Home/components/HomeBg'
import HomeContent from '@/pages/Home/components/HomeContent'
import AuthUtil from '@/utils/auth'
import OrderHelper from '@/pages/Home/helper/order'
import {Toast} from "@nutui/nutui-react";

const Home: React.FC = () => {
    const [params] = useSearchParams();
    const navigate = useNavigate();
    const [isAuthed, setIsAuthed] = useState(false);

    useEffect(() => {
        const authenticateAndFetchOrders = async () => {
            try {
                const authResult = await AuthUtil.auth(params);
                await OrderHelper.queryUserOrder(navigate);
                setIsAuthed(authResult);
            } catch (error) {
                Toast.show(`${error}`)
            }
        };

        authenticateAndFetchOrders();
    }, []);

    return (
        <div className={styles.wrap}>
            {isAuthed && (
                <>
                    <HomeBg />
                    <HomeContent />
                </>
            )}
        </div>
    );
};

export default Home;
