import React, {useEffect, useState} from "react";
import {useSearchParams} from "react-router-dom";
import apis from "@/apis";
import {type QueryOrderInfoResponse} from "@/apis/common";
import styles from "./index.module.scss";
import {Divider, Skeleton} from "@nutui/nutui-react";

const OrderDetail: React.FC = () => {
    const [params] = useSearchParams();
    const [orderInfo, setOrderInfo] = useState<QueryOrderInfoResponse>();
    const [checked, setChecked] = useState(false);

    history.pushState(null, '', document.URL);

    useEffect(() => {

        const handleBackButtonEvent = (e: PopStateEvent) => {
            e.preventDefault();

            history.pushState(null, '', document.URL);

            window.AlipayJSBridge.call("abcExitWebAndBackToHome");
        };

        window.addEventListener("popstate", handleBackButtonEvent);

        apis.common.queryOrderInfo(params.get("orderId") || "").then(res => {
            if (res.ok) {
                setOrderInfo(res.data);
                setChecked(true);
            }
        });

        return () => {
            window.removeEventListener("popstate", handleBackButtonEvent);
        };
    }, []);

    return (
        <div className={styles.wrap}>
            <div className={styles.contentWrap}>
                <Skeleton rows={2} title animated visible={checked}>
                    <div className={styles.contentTitle}>商品详情</div>
                    <div className={styles.contentItem}>
                        <span className={styles.contentItemLabel}>商品名称：</span>
                        <span className={styles.contentItemValue}>{orderInfo?.productDetailInfo.productName}</span>
                    </div>
                    <div className={styles.contentItem}>
                        <span className={styles.contentItemLabel}>支付金额：</span>
                        <span
                            className={styles.contentItemAmount}>￥<span>{orderInfo?.orderDetail.orderAmount}</span></span>
                    </div>
                </Skeleton>
            </div>
            <div className={styles.contentWrap}>
                <Skeleton rows={4} title animated visible={checked}>
                    <div className={styles.contentTitle}>订单详情</div>
                    <div className={styles.contentItem}>
                        <span className={styles.contentItemLabel}>机构编码：</span>
                        <span className={styles.contentItemValue}>{orderInfo?.orderDetail.branchCode}</span>
                    </div>
                    <div className={styles.contentItem}>
                        <span className={styles.contentItemLabel}>所属网点：</span>
                        <span className={styles.contentItemValue}>{orderInfo?.orderDetail.branchName}</span>
                    </div>
                    <Divider/>
                    <div className={styles.contentItem}>
                        <span className={styles.contentItemLabel}>支付时间：</span>
                        <span className={styles.contentItemValue}>{orderInfo?.orderDetail.payTime}</span>
                    </div>
                    <div className={styles.contentItem}>
                        <span className={styles.contentItemLabel}>下单账号：</span>
                        <span className={styles.contentItemValue}>{orderInfo?.orderDetail.mobile}</span>
                    </div>
                </Skeleton>
            </div>
        </div>
    );
};

export default OrderDetail;
