import React from 'react'
import ReactDOM from 'react-dom/client'
import { BrowserRouter, Routes, Route } from 'react-router-dom'
import Home from '@/pages/Home'
import Lottery from '@/pages/Lottery'
import OrderDetail from '@/pages/OrderDetail'
import './styles/reset.css'
import './styles/nut-var.css'
import '@nutui/nutui-react/dist/style.css'

const root = ReactDOM.createRoot(document.getElementById('root')!)
root.render(
  <React.StrictMode>
      <BrowserRouter>
          <Routes>
              <Route path = '/' element={<Home />}></Route>
              <Route path = '/lottery' element={<Lottery />}></Route>
              <Route path = '/orderDetail' element={<OrderDetail />}></Route>
          </Routes>
      </BrowserRouter>
  </React.StrictMode>
)
