import React, {useEffect, useState} from "react";
import homeProductBanner1Img from "@/assets/images/homeProductBanner1.png";
import homeProductBanner2Img from "@/assets/images/homeProductBanner2.png";
import homeRulesOverlayCloseImg from "@/assets/images/homeRulesOverlayClose.png";
import homeLogoImg from "@/assets/images/homeLogo.png";
import styles from "@/pages/Home/index.module.scss";
import HomeProductItem from "@/pages/Home/components/HomeProductItem";
import {Overlay, Popup, Toast} from "@nutui/nutui-react";
import HomeRuleContent from "@/pages/Home/components/HomeRuleContent";
import apis from "@/apis";
import type {ProductCode, QueryBranchListResponseData} from "@/apis/common";
import OrderHelper from "@/pages/Home/helper/order";

interface HomeContentProps {
    queryUserOrders: () =>  Promise<void>;
}

const HomeContent: React.FC<HomeContentProps> = (props) => {
    const [productList] = useState([
        {
            bannerImg: homeProductBanner1Img,
            title: "厅堂礼品 0元购",
            buttonTextColor: "#F41E71",
            productCode: "4",
            buttonText: "立即购买"
        },
        {
            bannerImg: homeProductBanner2Img,
            title: "微信立减金抽奖100%中奖",
            buttonTextColor: "#1FA189",
            productCode: "5",
            buttonText: "立即抽奖"
        }
    ]);

    const [branchList, setBranchList] = useState<QueryBranchListResponseData[]>([]);
    const [rulesOverlayVisible, setRulesOverlayVisible] = useState(false);
    const [showBranchListPopup, setShowBranchListPopup] = useState(false);
    const [activeBranchIdx, setActiveBranchIdx] = useState(-1);
    const [activeProductIdx, setActiveProductIdx] = useState(-1);
    const [toasted, setToasted] = useState(false);

    async function handleClickProduct(idx: number) {
        await props.queryUserOrders()

        if (toasted) {
            setActiveProductIdx(idx);
            setShowBranchListPopup(true);
        } else {
            Toast.show("请在网点工作人员指导下购买，每人仅有一次活动参与机会");
            setToasted(true);
        }
    }

    function handleConfirm() {
        if (activeBranchIdx === -1 || activeProductIdx === -1) return;
        const selectedBranch = branchList[activeBranchIdx];
        console.log(selectedBranch,'ces');
        const params = {
            branchName: selectedBranch.branchName,
            branchCode: selectedBranch.branchCode,
            productCode: productList[activeProductIdx].productCode as ProductCode,
            number: 1
        }
        setShowBranchListPopup(false);
        OrderHelper.submitOrder(params);
    }

    useEffect(() => {
        let isMounted = true;
        apis.common.queryBranchList().then(res => {
            if (isMounted && res.ok) {
                setBranchList(res.data);
            }
        }).catch(() => {
        });

        return () => {
            isMounted = false;
        };
    }, []);

    return (
        <div className={styles.contentWrap}>
            {productList.map((item, index) => {
                return (
                    <HomeProductItem
                        bannerImg={item.bannerImg}
                        title={item.title}
                        buttonTextColor={item.buttonTextColor}
                        buttonText={item.buttonText}
                        key={index}
                        idx={index}
                        onButtonClick={handleClickProduct}
                    />
                );
            })}

            <img className={styles.homeLogo} src={homeLogoImg} alt=""/>

            <div className={styles.productTips}>活动最终解释权归本行所有</div>

            {/* 网点列表 */}
            <Popup
                visible={showBranchListPopup}
                position="bottom"
                round
                onClose={() => {
                    setShowBranchListPopup(false);
                }
                }>
                <div className={styles.branchListPopupWrap}>
                    <div className={styles.branchListPopupHeader}>
                        <div className={styles.branchListPopupHeaderCancel} onClick={() => {
                            setShowBranchListPopup(false);
                            setActiveBranchIdx(-1);
                        }}>取消
                        </div>
                        <div className={styles.branchListPopupHeaderTitle}>选择营业网点</div>
                        <div className={styles.branchListPopupHeaderConfirm} onClick={handleConfirm}>确定</div>
                    </div>
                    <div className={styles.branchListPopupContent}>
                        {branchList.map((item, index) => {
                            return (
                                <div
                                    className={styles.branchListItem}
                                    onClick={() => {
                                        setActiveBranchIdx(index);
                                    }}
                                    key={item.branchCode}
                                    style={{
                                        color: activeBranchIdx === index ? "#e64545" : "",
                                        background: activeBranchIdx === index ? "#f7f7f7" : ""
                                    }}
                                >
                                    {item.branchName}
                                </div>
                            );
                        })}
                    </div>
                </div>
            </Popup>
            {/* 网点列表 */}

            {/* 活动规则 */}
            <div className={styles.contentRulesButton} onClick={() => {
                setRulesOverlayVisible(true);
            }}>活动规则
            </div>
            <Overlay
                visible={rulesOverlayVisible}
                closeOnOverlayClick={false}
                onClick={() => {
                    setRulesOverlayVisible(false);
                }}
            >
                <div className={styles.rulesOverlayWrap}>
                    <div className={styles.rulesOverlayContent}>
                        <img className={styles.rulesOverlayCloseImg} src={homeRulesOverlayCloseImg} onClick={() => {
                            setRulesOverlayVisible(false);
                        }} alt=""/>
                        <HomeRuleContent/>
                    </div>
                </div>
            </Overlay>
            {/* 活动规则 */}

        </div>
    );
};

export default HomeContent;
